<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Tax extends Model 
{

    protected $table = 'taxes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'percentage', 'pais_id');
    protected $visible = array('name', 'percentage', 'pais_id');

    public function pais()
    {
        return $this->belongsTo('Pais', 'pais_id')->withTrashed();
    }

}